'******************************************************************************
' Misc routines
' We need to decide where to place them finally
'******************************************************************************
'*******************************************************************************
'  Pollin NET-IO Board with Atmega32 / 644 / 644P and ENC28J60
'*******************************************************************************
'
'  Copyright bascom-forum.de (C) [2009]  [DON]
'  -> http://bascom-forum.de/index.php?topic=1781.new;topicseen#new
'  Software based on Code by Ben Zijlstra and Viktor Varga
'  Weiterentwickelt von
'    Huetti,
'    Michael
'    boeserkorn
'    mr_energy
'    HansHans
'    six1, Michael Kcher
'    dabuze                            datetime
'    framuel
'
'   http://creativecommons.org/licenses/by-sa/3.0/de/
'
'   Sie drfen:
'
'     * das Werk bzw. den Inhalt vervielfltigen, verbreiten und ffentlich zugnglich machen
'
'     * Abwandlungen und Bearbeitungen des Werkes bzw. Inhaltes anfertigen
'
'   Zu Den Folgenden Bedingungen:
'
'     * Namensnennung.
'       Sie mssen den Namen des Autors/Rechteinhabers in der von ihm festgelegten Weise nennen.
'
'     * Keine kommerzielle Nutzung.
'       Dieses Werk darf nicht fr kommerzielle Zwecke verwendet werden.
'
'     * Weitergabe unter gleichen Bedingungen.
'       Wenn Sie das lizenzierte Werk bzw. den lizenzierten Inhalt bearbeiten
'       oder in anderer Weise erkennbar als Grundlage fr eigenes Schaffen verwenden,
'       drfen Sie die daraufhin neu entstandenen Werke bzw. Inhalte nur
'       unter Verwendung von Lizenzbedingungen weitergeben, die mit denen
'       dieses Lizenzvertrages identisch oder vergleichbar sind.
'
'   Wobei gilt:
'
'     * Verzichtserklrung
'       Jede der vorgenannten Bedingungen kann aufgehoben werden, sofern Sie
'       die ausdrckliche Einwilligung des Rechteinhabers dazu erhalten.
'
'     * Sonstige Rechte
'       Die Lizenz hat keinerlei Einfluss auf die folgenden Rechte:
'          - Die gesetzlichen Schranken des Urheberrechts und sonstigen
'            Befugnisse zur privaten Nutzung
'          - Das Urheberpersnlichkeitsrecht des Rechteinhabers
'          - Rechte anderer Personen, entweder am Lizenzgegenstand selber oder
'            bezglich seiner Verwendung, zum Beispiel Persnlichkeitsrechte abgebildeter Personen.
'
'  Hinweis
'
'      Im Falle einer Verbreitung mssen Sie anderen alle Lizenzbedingungen
'      mitteilen, die fr dieses Werk gelten. Am einfachsten ist es,
'      einen Link auf http://creativecommons.org/licenses/by-sa/3.0/de/ einzubinden.
'

'*******************************************************************************
$nocompile                                                  'will compile only as an include file


'*******************************************************************************
'  SPI BUS configuration
'*******************************************************************************
#if Include_sdcard > 0
Sub Activate_sdcard
    Set Enc28j60_cs
    Config Spi = Hard , Interrupt = Off , Data Order = Msb , Master = Yes , Polarity = High , Phase = 1 , Clockrate = 4 , Noss = 1
'    Config Spi = Hard , Interrupt = Off , Data Order = Msb , Master = Yes , Polarity = High , Phase = 1 , Clockrate = 4 , Noss = 1 , Spiin = 0
    Set Spsr.spi2x0
    Spiinit
    Reset Mmc_cs
End Sub
#endif

#if Include_enc28j60 > 0
Sub Activate_enc28j60
    #if Include_sdcard > 0
       Set Mmc_cs
    #endif
    Config Spi = Hard , Interrupt = Off , Data Order = Msb , Master = Yes , Polarity = Low , Phase = 0 , Clockrate = 4 , Noss = 1 , Spiin = 0
   ' Set Spsr.spi2x0
   ' Reset Spsr.spi2x0
    Spiinit
    Reset Enc28j60_cs
End Sub
#endif


Function Reversed_word(byval Wd As Word) As Word
Local Lbl As Byte
Local Lbh As Byte
   Lbl = Low(wd)
   Lbh = High(wd)
   Reversed_word = Makeint(lbh , Lbl)
End Function


Function Bytes2long(byval Byte_lowest As Byte , Byval Byte_low As Byte , Byval Byte_high As Byte , Byval Byte_highest As Byte) As Long
   Local Ll As Long
   Ll = 256 * Byte_highest
   Ll = Ll + Byte_high
   Ll = 256 * Ll
   Ll = Ll + Byte_low
   Ll = 256 * Ll
   Bytes2long = Ll + Byte_lowest
End Function

'-------------------------------------------------------------------------------
' Print routines
'-------------------------------------------------------------------------------

#if Debug_dhcp > 2  or debug_arp > 0
Sub Print_ip(ip_addr As Byte , Byval Nl As Byte)
Local Laddr As Word
   Laddr = Varptr(ip_addr) : Print Inp(laddr);
   Incr Laddr : Print "." ; Inp(laddr);
   Incr Laddr : Print "." ; Inp(laddr);
   Incr Laddr : Print "." ; Inp(laddr);
   If Nl = 1 Then Print
End Sub
#endif

#if Debug_dhcp > 2  or debug_arp > 0
Sub Print_mac(mac_addr As Byte , Byval Nl As Byte)
Local Laddr As Word
   Laddr = Varptr(mac_addr) : Print Hex(inp(laddr));
   Incr Laddr : Print "-" ; Hex(inp(laddr));
   Incr Laddr : Print "-" ; Hex(inp(laddr));
   Incr Laddr : Print "-" ; Hex(inp(laddr));
   Incr Laddr : Print "-" ; Hex(inp(laddr));
   Incr Laddr : Print "-" ; Hex(inp(laddr));
   If Nl = 1 Then Print
End Sub
#endif

#if Debug_dhcp > 2
Sub Print_byte(byval Bt As Byte , Byval Nl As Byte)
   Print Hex(bt) ; "   (" ; Bt ; ")";
   If Nl = 1 Then Print
End Sub
#endif

#if Debug_dhcp > 2
Sub Print_word(byval Wd As Word , Byval Nl As Byte)
   Print Hex(low(wd)) ; Hex(high(wd)) ; "   (" ; Reversed_word(wd) ; ")" ;
   If Nl = 1 Then Print
End Sub
#endif

#if Debug_dhcp > 2
Sub Print_long(lg As Long , Byval Nl As Byte)
Local Laddr As Word
Local Lby1 As Byte
Local Lby2 As Byte
Local Lby3 As Byte
Local Lby4 As Byte
Local Ll As Long
   Laddr = Varptr(lg)
   Lby1 = Inp(laddr)
   Print Hex(lby1);
   Incr Laddr : Lby2 = Inp(laddr) : Print Hex(lby2);
   Incr Laddr : Lby3 = Inp(laddr) : Print Hex(lby3);
   Incr Laddr : Lby4 = Inp(laddr) : Print Hex(lby4);
   Ll = Bytes2long(lby4 , Lby3 , Lby2 , Lby1)
   Print "   (" ; Ll ; ")";
   If Nl = 1 Then Print
End Sub
#endif

#if Debug_dhcp > 2
Sub Print_hexbytes(bt As Byte , Byval Count As Byte , Byval Nl As Byte)
Local Laddr As Word
Local Lb As Byte
   Laddr = Varptr(bt) : Print Hex(inp(laddr));
   For Lb = 2 To Count
      Incr Laddr : Print ; Hex(inp(laddr));
   Next Lb
   If Nl = 1 Then Print
End Sub
#endif

'